<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Systeme extends Model 
{

    protected $table = 'systemes';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('libelle', 'logo', 'base_url', 'auth_url', 'register_url', 'username', 'password', 'access_token', 'status');

    public function linkedAccounts()
    {
        return $this->hasMany('App\Models\LinkedAccount');
    }

}